@extends('layouts.app')
@section('content')

<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View Sub Genre</h6>
            </div>

            @can(['create-subgenre'])
            <div class="view-all-release-search">
                <a href="{{ route('subgenre.create') }}"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            @endcan
           
        </div>


        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Genre</th>
                        <th>Sub Genre Name</th>
                        <th>Sub Genre Description</th>
                        <th>Sub Genre Status</th>
                        <th width="280px">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $subgenreObj)
                    <tr>
                        <td>{{ ++$i }}</td>

                        <td>
                            @php
                            $genreName = getGenreById($subgenreObj->genre_id);
                            echo $genreName->title;
                            @endphp
                        </td>

                        <td>{{ $subgenreObj->title }}</td>
                        <td>{{ $subgenreObj->description }}</td>
                        <td>

                        @can(['edit-subgenre'])
                            <input type="checkbox" id="genre_{{ $subgenreObj->id }}" class="form-check-input genreStatus" name="genreStatus" @if($subgenreObj->status==1) checked @endif />
                         @endcan


                            @if(!empty($subgenreObj->status))
                            <label id="genreStatus_{{ $subgenreObj->id }}" class="badge bg-success">Active</label>
                            @else
                            <label id="genreStatus_{{ $subgenreObj->id }}" class="badge bg-danger">Disabled</label>
                            @endif
                        </td>
                        <td>

                        @can(['edit-subgenre'])
                            <a class="btn btn-primary btn-sm" href="{{ route('subgenre.edit',$subgenreObj->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                        @endcan

                        @can(['delete-subgenre'])
                            <form method="POST" action="{{ route('subgenre.destroy', $subgenreObj->id) }}" style="display:inline">
                                @csrf
                                @method('DELETE')
                                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
                            </form>
                        @endcan

                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $data->links('pagination::bootstrap-5') !!}
        </div>
    </div>
</section>


<script>
    $(document).ready(function() {
        $(".genreStatus").change(function() {
            var genreStr = $(this).attr('id');
            var genreArr = genreStr.split("_");
            var genreId = genreArr[1];


            $.ajax({
                url: "{{route('subgenre.status.update')}}",
                type: "POST",
                data: {
                    genreId: genreId,
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(requestResponse) {

                    var genreStatusId = "genreStatus_" + genreId;

                    if (requestResponse == "disabledGenre") {
                        $(this).prop('checked', false);
                        $("#" + genreStatusId).removeClass("bg-success");
                        $("#" + genreStatusId).addClass("bg-danger");
                        $("#" + genreStatusId).text("Disabled");
                    } else if (requestResponse == "activeGenre") {
                        $(this).prop('checked', true);
                        $("#" + genreStatusId).addClass("bg-success");
                        $("#" + genreStatusId).removeClass("bg-danger");
                        $("#" + genreStatusId).text("Active");
                    }

                },

                error: function(response) {
                    alert('Something went wrong!');
                    console.log(response);
                    return false;
                }

            });

        });
    });
</script>

@endsection